#!/bin/bash

. /vagrant/shell/portal-admin/portal.dev.profile

echo "Installing Liferay Tomcat Bundle. Source: ${LIFERAY_TOMCAT_BUNDLE}"
echo "Install Location: ${BASE_DIRECTORY}"

unzip -q ${SOFTWARE_DIRECTORY}/${LIFERAY_TOMCAT_BUNDLE} -d ${BASE_DIRECTORY}

chown -R liferay:liferay ${LIFERAY_HOME}

echo "Updating Liferay Tomcat Context with Liferay Datasource jdbc/liferay."
sudo su - liferay -c "cp /vagrant/shell/portal-admin/tomcat-context.xml ${LIFERAY_TOMCAT_HOME}/conf/context.xml"
sudo su - liferay -c "sed -i.bak 's/SID/${ORCACLE_SID}/g' ${LIFERAY_TOMCAT_HOME}/conf/context.xml"

echo "Updating the Tomcat environment."
sudo su - liferay -c "cp /vagrant/shell/portal-admin/tomcat-setenv.sh ${LIFERAY_TOMCAT_HOME}/bin/setenv.sh"

echo "Removing unecessary Liferay plugins from Tomcat deployments."
rm -rf ${LIFERAY_TOMCAT_HOME}/webapps/opensocial-portlet

echo "Install the Oracle JDBC Driver in the Liferay Tomcat library extensions folder."
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/ojdbc6-11.1.0.7.0.jar $LIFERAY_TOMCAT_HOME/lib/ext"

echo "Installing license file for Liferay 6.2 EE."
sudo su - liferay -c "ln -s /deploy ${LIFERAY_HOME}/deploy"
sudo su - liferay -c "cp ${SOFTWARE_DIRECTORY}/license-portaldevelopment-developer-6.2ee.xml ${LIFERAY_HOME}/deploy/" 

echo "Installing Liferay Properties file."
sudo su - liferay -c "cp /vagrant/shell/portal-admin/portal-ext.properties ${LIFERAY_HOME}/"
sudo su - liferay -c "cp /vagrant/shell/portal-admin/portal-setup-wizard.properties ${LIFERAY_HOME}/"

echo "sudo su - liferay -c \"sed -i.bak 's/FOLDER/${LIFERAY_FOLDER}/g' ${LIFERAY_HOME}/portal-setup-wizard.properties\""
sudo su - liferay -c "sed -i.bak 's/FOLDER/${LIFERAY_FOLDER}/g' ${LIFERAY_HOME}/portal-setup-wizard.properties"

#echo "Downloading the latest MHV-R Admin content. (Please be patient. This is a large file and may take a while to complete depending on your connection speed.)"
#sudo su - liferay -c "curl -sSo content.zip http://DNS/tools/mhv/SYST-content-latest.zip"
#sudo su - liferay -c "unzip content.zip -d ${LIFERAY_HOME}/data/"

#echo "Installing common locally in ${TOMCAT_HOME}/lib."
#sudo su - liferay -c "curl -sSo ${LIFERAY_TOMACT_HOME}/lib/jsf-api-2.2.12.jar http://DNS:PORT/nexus/service/local/repositories/central/content/com/sun/faces/jsf-api/2.2.12/jsf-api-2.2.12.jar"
#sudo su - liferay -c "curl -sSo ${LIFERAY_TOMACT_HOME}/lib/jsf-impl-2.2.12.jar http://DNS:PORT/nexus/service/local/repositories/central/content/com/sun/faces/jsf-impl/2.2.12/jsf-impl-2.2.12.jar"
#sudo su - liferay -c "cp /installs/jsf-*-2.2*.jar ${LIFERAY_TOMCAT_HOME}/lib && chmod 644 ${LIFERAY_TOMCAT_HOME}/lib/jsf-*-2.2*.jar"

#echo "Installing Audience Targeting Plugin in Liferay. Plugin will install after Tomcat / Liferay startup."
#sudo su - liferay -c "curl -sSo ${LIFERAY_HOME}/AudienceTargeting.lpkg http://DNS/tools/liferay/Audience%20Targeting%20EE.lpkg"
#sudo su - liferay -c "cp ${LIFERAY_HOME}/AudienceTargeting.lpkg ${LIFERAY_HOME}/deploy/"
